// ModalWindowHelper.js
var popupIds = new Array();
popupIds[0] = "helpMsgPopUp";
popupIds[1] = "cvvHelpPopUp";
popupIds[2] = "tooltip";
popupIds[3] = "tooltipEntity";

function updateMargin(id) {
    try {
	// check if the id exists
	var elemnt = document.getElementById(id);
	var dir = $('html').attr('dir');

	if (elemnt != null && elemnt.style.display == 'block') {
	    // Changed to portrait
	    // Recalculate position
	    var modal_width = $('#' + id).outerWidth();

	    if (dir == 'ltr') {
		$('#' + id).css( {
		    'margin-left' : -(modal_width / 2) + 'px'
		});
	    } else {
		$('#' + id).css( {
		    'margin-right' : -(modal_width / 2) + 'px'
		});
	    }
	}
    } catch (exception_e) {
	// Do nothing
    }
}

function updatePopups() {
    try {
	if (popupIds != null) {
	    for ( var i = 0; i < popupIds.length; i++) {
		// alert(popupIds[i]);
		updateMargin(popupIds[i]);
	    }
	}
    } catch (exception_e) {
	// Do nothing
    }
}

$(document).ready(
	function() {
	    try {
		if (typeof window.orientation === 'undefined') {
		    var orientationChanged = window
			    .matchMedia("(orientation: portrait)");

		    orientationChanged.addListener( function(m) {
			updatePopups();
		    });
		} else {
		    window.addEventListener('resize', function() {
			updatePopups();
		    }, true);
		}
	    } catch (exception_e) {
		// Do nothing
	    }
	});
